/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import java.util.LinkedList;
import java.util.List;
import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.nativeCode.INativeCodeSequence;
import jpcsp.Memory;

public class NativeCodeSequence {
    protected String name;
    protected NativeOpcodeInfo[] opcodes = new NativeOpcodeInfo[0];
    private Class<INativeCodeSequence> nativeCodeSequenceClass;
    private ParameterInfo[] parameters = new ParameterInfo[0];
    private int branchInstruction = -1;
    private boolean isReturning = false;
    private boolean wholeCodeBlock = false;
    private String methodName = "call";
    private List<CodeInstruction> beforeCodeInstructions;
    private boolean isHook = false;
    private boolean isMethodReturning = false;

    public NativeCodeSequence(String name, Class<INativeCodeSequence> nativeCodeSequenceClass) {
        this.name = name;
        this.nativeCodeSequenceClass = nativeCodeSequenceClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addOpcode(int opcode, int mask, String label) {
        NativeOpcodeInfo[] newOpcodes = new NativeOpcodeInfo[this.opcodes.length + 1];
        System.arraycopy(this.opcodes, 0, newOpcodes, 0, this.opcodes.length);
        this.opcodes = newOpcodes;
        this.opcodes[this.opcodes.length - 1] = new NativeOpcodeInfo(opcode, mask, label);
    }

    public int getFirstOpcode() {
        return this.opcodes[0].getOpcode();
    }

    public int getFirstOpcodeMask() {
        return this.opcodes[0].getMask();
    }

    public int getNumOpcodes() {
        return this.opcodes.length;
    }

    public Class<INativeCodeSequence> getNativeCodeSequenceClass() {
        return this.nativeCodeSequenceClass;
    }

    public void setNativeCodeSequenceClass(Class<INativeCodeSequence> nativeCodeSequenceClass) {
        this.nativeCodeSequenceClass = nativeCodeSequenceClass;
    }

    public int getLabelIndex(String label) {
        int value = -1;
        if (label == null) {
            return value;
        }
        for (int i = 0; i < this.opcodes.length; ++i) {
            if (!label.equalsIgnoreCase(this.opcodes[i].getLabel())) continue;
            value = i;
            break;
        }
        return value;
    }

    public boolean isMatching(int opcodeIndex, int opcode) {
        return this.opcodes[opcodeIndex].isMatching(opcode);
    }

    public void setParameter(int parameter, int value, boolean isLabelIndex) {
        if (parameter >= this.parameters.length) {
            ParameterInfo[] newParameters = new ParameterInfo[parameter + 1];
            System.arraycopy(this.parameters, 0, newParameters, 0, this.parameters.length);
            for (int i = this.parameters.length; i < parameter; ++i) {
                newParameters[i] = null;
            }
            this.parameters = newParameters;
        }
        this.parameters[parameter] = new ParameterInfo(value, isLabelIndex);
    }

    public int getParameterValue(int parameter, int address) {
        if (parameter >= this.parameters.length) {
            return 0;
        }
        ParameterInfo parameterInfo = this.parameters[parameter];
        if (address == 0) {
            return parameterInfo.getValue();
        }
        return parameterInfo.getValue(address, this.opcodes);
    }

    public int getNumberParameters() {
        return this.parameters.length;
    }

    public int getBranchInstruction() {
        return this.branchInstruction;
    }

    public void setBranchInstruction(int branchInstruction) {
        this.branchInstruction = branchInstruction;
    }

    public boolean hasBranchInstruction() {
        return this.branchInstruction >= 0;
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        result.append("[");
        for (i = 0; this.opcodes != null && i < this.opcodes.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(String.format("%08X", this.opcodes[i].getOpcode()));
        }
        result.append("]");
        result.append("(");
        for (i = 0; i < this.getNumberParameters(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(this.getParameterValue(i, 0));
        }
        result.append(")");
        return result.toString();
    }

    public boolean isReturning() {
        return this.isReturning;
    }

    public void setReturning(boolean isReturning) {
        this.isReturning = isReturning;
    }

    public boolean isWholeCodeBlock() {
        return this.wholeCodeBlock;
    }

    public void setWholeCodeBlock(boolean wholeCodeBlock) {
        this.wholeCodeBlock = wholeCodeBlock;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<CodeInstruction> getBeforeCodeInstructions() {
        return this.beforeCodeInstructions;
    }

    public void addBeforeCodeInstruction(CodeInstruction codeInstruction) {
        if (this.beforeCodeInstructions == null) {
            this.beforeCodeInstructions = new LinkedList<CodeInstruction>();
        }
        this.beforeCodeInstructions.add(codeInstruction);
    }

    public boolean isHook() {
        return this.isHook;
    }

    public void setHook(boolean isHook) {
        this.isHook = isHook;
    }

    public boolean isMethodReturning() {
        return this.isMethodReturning;
    }

    public void setMethodReturning(boolean isMethodReturning) {
        this.isMethodReturning = isMethodReturning;
    }

    private static class ParameterInfo {
        private int value;
        private boolean isLabelIndex;

        public ParameterInfo(int value, boolean isLabelIndex) {
            this.value = value;
            this.isLabelIndex = isLabelIndex;
        }

        public int getValue() {
            return this.value;
        }

        public int getValue(int address, NativeOpcodeInfo[] opcodes) {
            if (this.isLabelIndex && this.value >= 0 && this.value < opcodes.length) {
                int labelAddress = address + (this.value << 2);
                int targetOpcode = Memory.getInstance().read32(labelAddress);
                NativeOpcodeInfo opcode = opcodes[this.value];
                return targetOpcode & opcode.getNotMask();
            }
            return this.value;
        }
    }

    private static class NativeOpcodeInfo {
        private int opcode;
        private int mask;
        private int notMask;
        private String label;
        private int maskedOpcode;

        public NativeOpcodeInfo(int opcode, int mask, String label) {
            this.opcode = opcode;
            this.mask = mask;
            this.label = label;
            this.maskedOpcode = opcode & mask;
            this.notMask = ~mask;
        }

        public boolean isMatching(int opcode) {
            return (opcode & this.mask) == this.maskedOpcode;
        }

        public int getOpcode() {
            return this.opcode;
        }

        public String getLabel() {
            return this.label;
        }

        public int getMask() {
            return this.mask;
        }

        public int getNotMask() {
            return this.notMask;
        }
    }
}

